// Clap One Time Bulb ON, Clap Two Time Bulb OFF

// Define pins
const int soundSensorPin = 2;  // Pin connected to the sound sensor OUT pin
const int relayPin = 3;        // Pin connected to the relay module IN pin

// Variables
int soundState = LOW;           // Variable to store the state of the sound sensor
int previousSoundState = LOW;   // Variable to store the previous state of the sound sensor
int clapCount = 0;              // Counter for the number of claps detected
unsigned long clapTimer = 0;    // Timer to measure time between claps
const unsigned long clapDelay = 500; // Maximum time between claps (in milliseconds)

void setup() {
  pinMode(soundSensorPin, INPUT);  // Set sound sensor pin as input
  pinMode(relayPin, OUTPUT);       // Set relay pin as output
  digitalWrite(relayPin, LOW);     // Initially turn off the relay
  Serial.begin(9600);              // Initialize serial communication for debugging
}

void loop() {
  soundState = digitalRead(soundSensorPin);  // Read the state of the sound sensor

  // Detect clap (sound detected)
  if (soundState == HIGH && previousSoundState == LOW) {
    clapCount++;  // Increment the clap counter
    clapTimer = millis();  // Reset the clap timer

    // Debugging output
    Serial.print("Clap detected. Clap count: ");
    Serial.println(clapCount);

    // Add a small delay to debounce the sound sensor
    delay(200);
  }

  // Check if a single clap was detected and enough time has passed to consider it a single clap
  if (clapCount == 1 && millis() - clapTimer > clapDelay) {
    digitalWrite(relayPin, HIGH);  // Turn on the relay
    Serial.println("Relay ON");
    clapCount = 0;  // Reset clap count
  }

  // Check if two claps were detected within the delay time
  if (clapCount == 2) {
    digitalWrite(relayPin, LOW);  // Turn off the relay
    Serial.println("Relay OFF");
    clapCount = 0;  // Reset clap count
  }

  // Reset the previous sound state for the next loop
  previousSoundState = soundState;
}
