#define BLYNK_TEMPLATE_ID "TMPL31DS_QZsY"
#define BLYNK_TEMPLATE_NAME "Multiline detection"
#define BLYNK_AUTH_TOKEN "Enter Your Token Here "

#include <WiFi.h>
#include <WiFiClient.h>
#include <BlynkSimpleEsp32.h>

// WiFi credentials
char ssid[] = "Enter Your Hotspot Name here";
char pass[] = "123456789";

// Blynk authentication token
char auth[] = "Enter Your Token Here";

// Pins for fault detection
int pin1 = 13;  // Example: GPIO 13
int pin2 = 12;  // Example: GPIO 12
int pin3 = 14;  // Example: GPIO 14 - Fire detection pin

// Pins for relay control
int relayPin1 = 25;  // Example: GPIO 25 for relay 1
int relayPin2 = 26;  // Example: GPIO 26 for relay 2

// Buzzer pin
int buzzerPin = 27;  // Example: GPIO 27 for the buzzer

void setup() {
  // Debug console
  Serial.begin(115200);

  // Connect to WiFi
  WiFi.begin(ssid, pass);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.println("Connecting to WiFi...");
  }
  Serial.println("Connected to WiFi");

  // Initialize Blynk
  Blynk.begin(auth, ssid, pass, "blynk.cloud", 80);
  Serial.println("Connected to Blynk");

  // Setup pins for input
  pinMode(pin1, INPUT_PULLUP);
  pinMode(pin2, INPUT_PULLUP);
  pinMode(pin3, INPUT_PULLUP);

  // Setup pins for relay output
  pinMode(relayPin1, OUTPUT);
  pinMode(relayPin2, OUTPUT);

  // Setup buzzer pin
  pinMode(buzzerPin, OUTPUT);
  digitalWrite(buzzerPin, LOW);  // Ensure buzzer is off at the beginning
}

void loop() {
  // Read the state of the pins
  int state1 = digitalRead(pin1);
  int state2 = digitalRead(pin2);
  int state3 = digitalRead(pin3);

  // Check for fault condition
  if (state1 != state2) {
    Serial.println("Fault detected!");

    // Send notification to Blynk app
    Blynk.logEvent("fault_alert", "Fault Detected");

    // Control relay 1
    digitalWrite(relayPin1, LOW); // Turn on relay 1

    // Trigger a virtual pin or LED on the app
    Blynk.virtualWrite(V1, HIGH); // Assuming V1 is a virtual LED widget

    // Activate buzzer for 5 seconds
    digitalWrite(buzzerPin, HIGH); // Turn on buzzer
    delay(5000);                    // Wait for 5 seconds
    digitalWrite(buzzerPin, LOW);  // Turn off buzzer

    // Wait a bit before sending another notification
    delay(5000);
  } else {
    // Turn off relay 1
    digitalWrite(relayPin1, HIGH);

    // Turn off the fault detection LED
    Blynk.virtualWrite(V1, LOW);

    // Ensure buzzer is off when no fault
    digitalWrite(buzzerPin, LOW);
  }

  // Check for fire detection
  if (state3 == LOW) {  // Assuming LOW indicates fire detection
    Serial.println("Fire detected!");

    // Send notification to Blynk app
    Blynk.logEvent("fire_alert", "Fire Detected");

    // Control relay 2
    digitalWrite(relayPin2, LOW); // Turn on relay 2

    // Trigger a virtual pin or LED on the app
    Blynk.virtualWrite(V2, HIGH); // Assuming V2 is another virtual LED widget for fire detection

    // Activate buzzer for 5 seconds
    digitalWrite(buzzerPin, HIGH); // Turn on buzzer
    delay(5000);                    // Wait for 5 seconds
    digitalWrite(buzzerPin, LOW);  // Turn off buzzer

    // Wait a bit before sending another notification
    delay(5000);
  } else {
    // Turn off relay 2
    digitalWrite(relayPin2, HIGH);

    // Turn off the fire detection LED
    Blynk.virtualWrite(V2, LOW);

    // Ensure buzzer is off when no fire
    digitalWrite(buzzerPin, LOW);
  }

  // Run Blynk process
  Blynk.run();
}
